--[ja] ボスフォルダ関係の命令 
--[[
	EXF_ScreenTitleMenu_background();
	EXF_ScreenSelectMusic_decorations();
	EXF_ScreenStageInformation_underlay();
	EXF_ScreenGameplay();
	EXF_ScreenEvaluation();
--]]

function EXF_ScreenTitleMenu()
	return Def.Actor{
		InitCommand=cmd(visible,false);
		OnCommand=function(self)
			EXF_ScreenTitleMenu_On();
		end;
	};
end;

function EXF_ScreenTitleMenu_On()
	-- [ja] ExFolderの設定が残っている場合削除 
	if getenv("ExFolderFlag") then
		if getenv("ExFolderFlag")~="" then
			EXF_Cancel();
		end;
	end;
end;

function EXF_ScreenSelectMusic()
	return Def.Actor{
		InitCommand=cmd(visible,false);
		BeginCommand=function(self)
			EXF_ScreenSelectMusic_Begin();
		end;
	};
end;

function EXF_ScreenSelectMusic_Begin()
	setenv("EXF_NowStage","0");
	if not GAMESTATE:IsCourseMode() then
		if STATSMAN:GetCurStageStats():GetStageIndex()==0 then
			EXF_Cancel();

		-- [ja] 強制EX2専用フォルダ 
		elseif getenv("ExFolderFlag")=="Ex1Result"
			and GetGroupParameter(getenv("ExGroupName"),"Extra2List")~="" then
			setenv("ExFolderFlag","Ex2SelectMusic");
			SCREENMAN:SetNewScreen("ScreenEXFolderIntro");

		elseif getenv("ExFolderFlag")=="Ex1GamePlay" then
			setenv("ExFolderFlag","Ex1SelectMusic");
			SCREENMAN:SetNewScreen("ScreenSelectExMusic");

		elseif getenv("ExFolderFlag")=="Ex2GamePlay" then
			setenv("ExFolderFlag","Ex2SelectMusic");
			SCREENMAN:SetNewScreen("ScreenSelectExMusic");

		elseif getenv("ExGroupName")~="" then
		--	GAMESTATE:ApplyGameCommand( "mod,bar");
		--	MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			EXF_Cancel();
		end;
	else
		EXF_Cancel();
	end;
end;

function EXF_Cancel()
	setenv("ExLifeLevel","Normal");
	setenv("ExGroupName","");
	setenv("ExFolderFlag","");
	setenv("ExDifficultyP1","");
	setenv("ExDifficultyP2","");
	setenv("ExDialog",nil);
end;

function EXF_ScreenStageInformation()
	return Def.Actor{
		InitCommand=function(self)
			setenv("ExUltimateLifeFlag",false);
			setenv("ExUltimateLife",false);
			EXF_ScreenStageInformation_Init();
		end;
		CodeCommand=function(self,params)
			if not getenv("Drill") and not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2() then
				if params.Name=="UltimateLife" and not getenv("ExUltimateLifeFlag") then
					setenv("ExUltimateLife",true);
				end;
			end;
		end;
	};
end;

function EXF_ScreenStageInformation_Init()
	if GAMESTATE:IsAnExtraStage()
		and getenv("ExFolderFlag")=="" then
		if GAMESTATE:GetPreferredSongGroup() == "---Group All---" then
			local song = GAMESTATE:GetCurrentSong()
			GAMESTATE:SetPreferredSongGroup( song:GetGroupName() )
		end

		local bExtra2 = GAMESTATE:IsExtraStage2()
		local style = GAMESTATE:GetCurrentStyle()
		local song, steps = SONGMAN:GetExtraStageInfo( bExtra2, style )
		local po, so
		local f=OpenFile("/Songs/"..GetActiveGroupName().."/extra"..(bExtra2 and "2" or "1")..".crs");
		if not f then
			f=OpenFile("/AdditionalSongs/"..GetActiveGroupName().."/extra"..(bExtra2 and "2" or "1")..".crs");
		end;
		if f then
			local opt=split(":",GetFileParameter(f,"song"))[3];
			local opt=string.lower(opt);
			local life=GetFileParameter(f,"lives");
			local lf=0;
			local exll="Normal";
			if bExtra2 then
				if life=="" or life=="1" then
					life="1 life";
					lf=1;
				else
					lf=tonumber(life);
					life=""..life.." lives";
				end;
			else
				if life=="" then
					life="4 lives";
					lf=4;
				elseif life=="1" then
					life="1 life";
					lf=1;
				else
					lf=tonumber(life);
					life=""..life.." lives";
				end;
			end;
			if string.find(opt,"battery",0,true) then
				so="faildefault,battery,"..life.."";
			elseif string.find(opt,"norecover",0,true) then
				so="bar,failimmediate,norecover";
				exll="NoRecover";
			elseif string.find(opt,"suddendeath",0,true) then
				so="bar,failimmediate,suddendeath";
				exll="Suddendeath";
			else
				so="bar,failimmediate,normal-drain";
			end;
			opt=string.gsub(opt,",",", ");
			CloseFile(f);
			for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
				local ps = GAMESTATE:GetPlayerState(pn);
				local modstr = "default, " .. ps:GetPlayerOptionsString("ModsLevel_Preferred")..", "..opt;
				ps:SetPlayerOptions("ModsLevel_Preferred", modstr);
				ps:SetPlayerOptions('ModsLevel_Song', modstr);
			end;
			GAMESTATE:SetSongOptions( "ModsLevel_Stage", so );
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			if GetSMVersion()>30 then
				-- [ja] b4のライフはバグでうまく設定されない 
				for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
					local ps=GAMESTATE:GetPlayerState(pn);
					local po;
					if lf>0 then
						po=ps:GetPlayerOptions('ModsLevel_Stage');
						po:LifeSetting('LifeType_Battery');
						po:BatteryLives(lf);
						po=ps:GetPlayerOptions('ModsLevel_Preferred');
						po:LifeSetting('LifeType_Battery');
						po:BatteryLives(lf);
					else
						if exll=="NoRecover" then
							po=ps:GetPlayerOptions('ModsLevel_Stage');
							po:DrainSetting('DrainType_NoRecover');
							po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:DrainSetting('DrainType_NoRecover');
						elseif exll=="Suddendeath" then
							po=ps:GetPlayerOptions('ModsLevel_Stage');
							po:DrainSetting('DrainType_SuddenDeath');
							po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:DrainSetting('DrainType_SuddenDeath');
						else
							po=ps:GetPlayerOptions('ModsLevel_Stage');
							po:DrainSetting('DrainType_Normal');
							po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:DrainSetting('DrainType_Normal');
						end;
					end;
					MESSAGEMAN:Broadcast( "PlayerOptionsChanged", {PlayerNumber = pn} );
				end;
			end;
			--[[
			if GetSMVersion()>30 and lf>0 then
				-- [ja] b4のライフはバグでうまく設定されない 
				for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
					local ps=GAMESTATE:GetPlayerState(pn);
					local po=ps:GetPlayerOptions('ModsLevel_Song');
					po:LifeSetting('LifeType_Battery');
					po:BatteryLives(lf);
					po=ps:GetPlayerOptions('ModsLevel_Preferred');
					po:LifeSetting('LifeType_Battery');
					po:BatteryLives(lf);
				end;
			end;
			for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
				local ps = GAMESTATE:GetPlayerState(pn);
				local modstr = "default, " .. ps:GetPlayerOptionsString("ModsLevel_Preferred")..", "..opt;
				ps:SetPlayerOptions("ModsLevel_Preferred", modstr);
				ps:SetPlayerOptions('ModsLevel_Song', modstr);
			end;
			GAMESTATE:SetSongOptions( "ModsLevel_Stage", so );
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			--]]
			so=nil;
		else
			if bExtra2 then
				po = THEME:GetMetric("SongManager","OMESPlayerModifiers");
				so = THEME:GetMetric("SongManager","OMESStageModifiers");
			else
				po = THEME:GetMetric("SongManager","ExtraStagePlayerModifiers");
				so = THEME:GetMetric("SongManager","ExtraStageStageModifiers");
			end;
		end;
		
		if po or so then
			local difficulty = steps:GetDifficulty()
			local Reverse = PlayerNumber:Reverse()

			GAMESTATE:SetCurrentSong( song )
			GAMESTATE:SetPreferredSong( song )

			for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
				GAMESTATE:SetCurrentSteps( pn, steps )
				GAMESTATE:GetPlayerState(pn):SetPlayerOptions( "ModsLevel_Stage", po )
				GAMESTATE:SetPreferredDifficulty( pn, difficulty )
				MESSAGEMAN:Broadcast( "PlayerOptionsChanged", {PlayerNumber = pn} )
			end
			GAMESTATE:SetSongOptions( "ModsLevel_Stage", so )
			MESSAGEMAN:Broadcast( "SongOptionsChanged" )
		end;
	elseif getenv("ExFolderFlag")=="Ex1GamePlay"
		or getenv("ExFolderFlag")=="Ex2GamePlay" then
		if GetSMVersion()<=30 then
			-- [ja] 強制的に現在の設定を反映させることでEXステージでもプレイヤーオプションが初期化されない 
			for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
				local ps = GAMESTATE:GetPlayerState(pn);
				local modstr = "default, " .. ps:GetPlayerOptionsString("ModsLevel_Stage");
				ps:SetPlayerOptions("ModsLevel_Stage", modstr);
				MESSAGEMAN:Broadcast( "PlayerOptionsChanged", {PlayerNumber = pn} )
			end;
			EXFolderLifeSetting();
		else
			EXFolderLifeSetting();
		end;
	end;
end;

local failed_chk=false;
function EXF_ScreenGameplay()
	local function updateEXFGame(self,dt)
		if getenv("ExFolderFlag") and getenv("ExFolderFlag")~="" then
			local live={GAMESTATE:IsPlayerEnabled(PLAYER_1),
						GAMESTATE:IsPlayerEnabled(PLAYER_2)};
			for p=1,2 do
				if live[p] then
					local pss=STATSMAN:GetCurStageStats():GetPlayerStageStats('PlayerNumber_P'..p);
					if pss then
						live[p]=(pss:GetCurrentLife()>0);
					end;
				end;
			end;
			if not failed_chk and not live[1] and not live[2] then
				failed_chk=true;
				local BGorBS=false;
				for p=1,2 do
					if not BGorBS and GAMESTATE:IsPlayerEnabled('PlayerNumber_P'..p) then
						local dif=GAMESTATE:GetCurrentSteps('PlayerNumber_P'..p):GetDifficulty();
						if dif==Difficulty[1] or dif==Difficulty[2] then
							BGorBS=true;
						end;
					end;
				end;
				if BGorBS then
					SCREENMAN:GetTopScreen():PostScreenMessage('SM_Pause', 0.5);
					SCREENMAN:GetTopScreen():PostScreenMessage('SM_BeginFailed', 0.5);
				end;
			end;
		end;
	end;
	return Def.ActorFrame{
		InitCommand=cmd(SetUpdateFunction,updateEXFGame);
		OnCommand=function(self)
			EXF_ScreenGameplay_On();
		end;
		OffCommand=function(self)
			EXF_ScreenGameplay_Off();
		end;
	};
end;

function EXF_ScreenGameplay_On()
	failed_chk=false;
	if getenv("ExFolderFlag")=="Ex1GamePlay" then
		setenv("EXF_NowStage","1");
	elseif getenv("ExFolderFlag")=="Ex2GamePlay" then
		setenv("EXF_NowStage","2");
	else
		setenv("EXF_NowStage","0");
	end;
end;

function EXF_ScreenGameplay_Off()
	if getenv("ExGroupName")~="" then
		setenv("ExLifeLevel","Normal");
	end;
end;

function EXF_ScreenEvaluation()
	return Def.Actor{
		OffCommand=function(self)
			EXF_ScreenEvaluation_Off();
		end;
	};
end;

function EXF_ScreenEvaluation_Off()
	local chk_grade=false;
	if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
		local player_grade=STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetGrade();
		if player_grade=="Grade_Tier01" or player_grade=="Grade_Tier02"
			or player_grade=="Grade_Tier03" then
			chk_grade=true;
		end;
	end;
	if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
		local player_grade=STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetGrade();
		if player_grade=="Grade_Tier01" or player_grade=="Grade_Tier02"
			or player_grade=="Grade_Tier03" then
			chk_grade=true;
		end;
	end;

	if getenv("ExFolderFlag") then
		if getenv("ExFolderFlag")=="Ex1GamePlay" and chk_grade then
			if GetSMVersion()>30 then
			-- [ja] Beta4以降はこっち 
				for p=1,2 do
					local pn=(p==1) and PLAYER_1 or PLAYER_2;
					if GAMESTATE:IsPlayerEnabled(pn) then
						local ps=GAMESTATE:GetPlayerState(pn);
						if ps then
							local po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:BatteryLives(4);
							po:LifeSetting('LifeType_Bar');
							po:DrainSetting('DrainType_Normal');
						end;
					end;
				end;
			else
				GAMESTATE:ApplyGameCommand( "mod,4 lives");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				GAMESTATE:ApplyGameCommand( "mod,bar");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				GAMESTATE:ApplyGameCommand( "mod,normal-drain");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			end;
			setenv("ExFolderFlag","Ex1Result");
			setenv("ExGroupName",GetActiveGroupName());
		elseif getenv("ExFolderFlag")=="Ex2GamePlay" or getenv("ExFolderFlag")=="Ex1GamePlay" then
			if GetSMVersion()>30 then
			-- [ja] Beta4以降はこっち 
				for p=1,2 do
					local pn=(p==1) and PLAYER_1 or PLAYER_2;
					if GAMESTATE:IsPlayerEnabled(pn) then
						local ps=GAMESTATE:GetPlayerState(pn);
						if ps then
							local po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:BatteryLives(4);
							po:LifeSetting('LifeType_Bar');
							po:DrainSetting('DrainType_Normal');
						end;
					end;
				end;
			else
				GAMESTATE:ApplyGameCommand( "mod,4 lives");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				GAMESTATE:ApplyGameCommand( "mod,bar");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				GAMESTATE:ApplyGameCommand( "mod,normal-drain");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			end;
			EXF_Cancel();
		else
		--[ja] ExFolder以外の場合、意図的にバッテリーライフにしている可能性があるので初期化しない 
		--[[
			GAMESTATE:ApplyGameCommand( "mod,bar");
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			GAMESTATE:ApplyGameCommand( "mod,normal-drain");
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
		--]]
			EXF_Cancel();
		end;
	end;
end;

-- [ja] EXF_LifeMeterXX は Drillモード実装のため 91 Life.lua に移動 
